local function fix_shell_ref(o)


	if  type(o) == 'string' then
		return shell_ref(o) or 
			   shell_ref('M134_7_62_T')
	elseif type(o) ~= 'table' then
		return shell_ref('M134_7_62_T')
	end
	return o;
end

local function fix_shells(shells)


	if type(shells) ~= 'table' then
		return {fix_shell_ref(shells)}
	elseif #shells == 0 then --already descriptor
		return {shells}
	end
   	for i,o in ipairs(shells) do
		shells[i] = fix_shell_ref(o)
	end
	return shells
end

 --TODO fix mass calculation !!!
function ammo_supply_mixed(tt)
	tt.shells = fix_shells(tt.shells)
 	tt.get_mass_ = function (t) return t.count * t.shells[1].round_mass end
	return dbtype("wAmmoSupplyMixed", tt);
end

function   ammo_supply_simple(table)
	return ammo_supply_mixed(table)

end

function ammo_supply_dual(tt)
	tt.shell1 = fix_shell_ref(tt.shell1)
	tt.shell2 = fix_shell_ref(tt.shell2)
 	tt.get_mass_ = function (t) return t.count1 * t.shell1.round_mass  + t.count2 * t.shell2.round_mass end
    return dbtype("wAmmoSupplyDual", tt);
end


function declare_gun_mount(name,tbl)

	local    gun_config  = tbl.gun    or {}
	local supply_config  = tbl.supply or {type = "wAmmoSupplyMixed"}
	--clean up, prepare for instancing dbtype
	tbl.supply = nil
	tbl.gun    = nil
	
    local res = dbtype("wAircraftGunMount",tbl);

	res.gun   = dbtype("wGun",gun_config)
	if res.gun.impulse_vec_rot == nil then
	   res.gun.impulse_vec_rot = {x = 0,y = 0,z = 0}
    end
	
	if res.drop_cartridge == nil then
	   res.drop_cartridge = 0
	end
	
	if res.gun.trigger == nil then
	  res.gun.trigger = {name ="GunTrigger"}
	end
	
	if res.effects == nil then
		res.effects = {{ name = "FireEffect", arg = 350 },{name = "SmokeEffect"}}
	end
	
	if  supply_config.type ~= nil and 
		supply_config.type == "wAmmoSupplyDual" then
		res.supply = ammo_supply_dual (supply_config)
	else --mixed
		res.supply = ammo_supply_mixed(supply_config)
	end
	if not res.short_name then 
		res.short_name = name
	end
	if not res.display_name then 
		res.display_name = res.short_name
	end
	
	res.supply.get_mass = function () return res.supply.get_mass_(res.supply) end        
   
    return res;
end


local cartridge_30mm  = 203
local cartridge_50cal = 204
local cartridge_308cal = 205

gun_mount_templates = {};

gun_mount_templates["GSh_23_2"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {3400},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("GSH23_23_HE_T")
  });
  
  effective_fire_distance = 1500;
}

gun_mount_templates["GSh_23_6"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 100000,
    rates = {9000},

    recoil_coeff 	= 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("GSH23_23_AP")
  });
  
  effective_fire_distance = 1500;
}

gun_mount_templates["GSh_30_1"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {1500},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("GSH301_30_HE")
  });
  
  effective_fire_distance = 1800;
}

gun_mount_templates["GSh_30_2"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {3000},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("GSH301_30_AP")
  });
  
  effective_fire_distance = 1800;
}

gun_mount_templates["GSh_30_6"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 100000,
    rates = {5000},

    recoil_coeff 	= 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("GSH301_30_AP")
  });
  
  effective_fire_distance = 1800;
}

gun_mount_templates["NR_30"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {900},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("HP30_30_AP")
  });
  drop_cartridge = cartridge_30mm;
  
  effective_fire_distance = 1800;

}

gun_mount_templates["2A42"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 20,
    rates = {600,300},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_dual({
    shell1 = shell_ref("2A42_30_HE"),
    shell2 = shell_ref("2A42_30_AP"),

    second_box_offset = {0, 0, 0}
  });
  
  drop_cartridge = cartridge_30mm;
  
  effective_fire_distance = 2000;
}

gun_mount_templates["YakB_12_7"] = 
{
  gun = dbtype("wGun",
  {

    max_burst_length = 400,
    rates = {4500},

    recoil_coeff 	= 0.5*1.3,
  });

  supply = ammo_supply_mixed({ 
	mixes  = { 
				{1,2}
			 },
    shells = {
				shell_ref("YakB_12_7_T"),
				shell_ref("YakB_12_7"),
			 }
				
  });
  
   drop_cartridge = cartridge_30mm;
   
   effective_fire_distance = 1300;
}

gun_mount_templates["GSHG_7_62"] = 
{
  gun = dbtype("wGun",
  {
	rates			    = {6000,3500},
    max_burst_length 	= 3200,
	recoil_coeff 	 	= 0.2*1.3,
  });

  supply = ammo_supply_mixed({ 
	mixes  = { 
				{2,2,2,2,1}
			 },
    shells = {
				shell_ref("PKT_7_62_T"),
				shell_ref("PKT_7_62"),
			 }
				
  });
  
  drop_cartridge = cartridge_50cal;

  effective_fire_distance = 1000;
}

gun_mount_templates["AP_30_PLAMYA"] = 
{
  gun = dbtype("wGun",
  {
	rates			    = {500},
    max_burst_length 	= 300,
	recoil_coeff 	 	= 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("VOG17")
  });
  
  effective_fire_distance = 1000;
}

gun_mount_templates["M_61"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 100000,
    rates = {6000},

	
    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("M61_20_HE")
  });
  
  effective_fire_distance = 1500;
}

gun_mount_templates["GAU_8"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 100000,
    rates = {4200,2100},

    recoil_coeff = 0.7*1.3,
    impulse_vec_rot = {
        y = 0.0,
        z = -0.3
    }
  });

  supply = ammo_supply_mixed({ 
	mixes  = { 
				{1,1,1,1,2},--CM Combat Mix  4xAP + 1HEI 
				{2},--HE only
				{3},--Target Practice
			 },
    shells = {
				shell_ref("GAU8_30_AP"),--AP
				shell_ref("GAU8_30_HE"),--HE
				shell_ref("GAU8_30_TP"),--Target Practice
			 }
				
  });
  
  effective_fire_distance = 2200;
}

gun_mount_templates["M_39"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {1500},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("M61_20_HE")
  });
  
  effective_fire_distance = 1500;
}

gun_mount_templates["BK_27"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {1700},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("BK_27")
  });
  drop_cartridge = cartridge_30mm;
  
  effective_fire_distance = 1600;
}

gun_mount_templates["ADEN"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {1400},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("DEFA552_30")
  });
  drop_cartridge = cartridge_30mm;
  
  effective_fire_distance = 1800;
}

gun_mount_templates["DEFA_554"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {1800},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("DEFA552_30")
  });
  drop_cartridge = cartridge_30mm;
  
  effective_fire_distance = 1800;
}

gun_mount_templates["M_230"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {620, 620},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("M230_30")
  });
  drop_cartridge = cartridge_30mm;
  
  effective_fire_distance = 1800;
}

gun_mount_templates["M_197"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {1500},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("M197_20")
  });
  drop_cartridge = cartridge_30mm;
  
  effective_fire_distance = 1500;
}

gun_mount_templates["M_2"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {800},

    recoil_coeff = 0.7*1.3,
  });

  
  supply = ammo_supply_mixed({ 
	mixes  = { 
				{1,1,1,2},--Combat Mix  3xAP + 1xAPIT 
				{1},--AP only
				{2},--APIT only
			 },
    shells = {
				shell_ref("M2_50_aero_AP"),--AP
				shell_ref("M20_50_aero_APIT"),--APIT
				
			 }
				
  });
  drop_cartridge = cartridge_50cal;
  
  effective_fire_distance = 1200;
}

gun_mount_templates["M_60"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {600},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("7_62x51")
  });
  
  drop_cartridge = cartridge_308cal;
  
  effective_fire_distance = 1500;
}

gun_mount_templates["M_134"] = 
{
  gun = dbtype("wGun",
  {
	rates			    = {4000,2000},
    max_burst_length 	= 3200,
	recoil_coeff 	 	= 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("M134_7_62_T")
  });
  
  drop_cartridge = cartridge_308cal;

  effective_fire_distance = 1500;
}


gun_mount_templates["GSh_23_UPK"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 10,
    rates = {3400},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("GSH23_23_HE_T")
  });
  
  drop_cartridge = cartridge_50cal;
  
  effective_fire_distance = 1500;
}

gun_mount_templates["GSh_23_SPUU22"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 25,
    rates = {3400},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("GSH23_23_HE_T")
  });
  
  drop_cartridge = cartridge_50cal;
  
  effective_fire_distance = 1500;
}

gun_mount_templates["M2_OH58D"] = 
{
  gun = dbtype("wGun",
  {
    max_burst_length = 10,
    rates = {800},

    recoil_coeff = 0.7*1.3,
  });

  supply = ammo_supply_simple({
    shells = shell_ref("M2_12_7_T")
  });
  
  drop_cartridge = cartridge_50cal;
  
  effective_fire_distance = 1500;
}


function p51m2(name,rate_setting,mix_setting)
	gun_mount_templates[name] = 
	{
	  gun = dbtype("wGun",
	  {
		max_burst_length = 500,
		rates 			 = { rate_setting or 800},
		recoil_coeff 	 = 0.7*1.3,
	  }); 
	  supply = ammo_supply_mixed({ 
		mixes  = { 
				    mix_setting or {1,1,1,2},--Combat Mix  3xAP + 1xAPIT 
					{1},--AP only
					{2},--APIT only
				 },
		shells = {
					shell_ref("M2_50_aero_AP"),--AP
					shell_ref("M20_50_aero_APIT"),--APIT
					
				 }
					
	  });
	  drop_cartridge = cartridge_50cal;
	  
	  effective_fire_distance = 1200;
	}
end









p51m2("M_2_L1",798,{1,1,1,1,1,1,1,2})
p51m2("M_2_L2",800,{1,2,1,1,1,1,1,1})
p51m2("M_2_L3",803,{1,1,2,1,1,1,1,1})
p51m2("M_2_R1",797,{1,1,1,2,1,1,1,1})
p51m2("M_2_R2",801,{1,1,1,1,2,1,1,1})
p51m2("M_2_R3",804,{1,1,1,1,1,2,1,1})
